/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.FileNotFoundException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorLazyStartProducerTest
extends ContextTestSupport {
    @Test
    public void testLazyStartProducerFail() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>"), (String)"Should throw exception");
        ValidatorLazyStartProducerTest.assertIsInstanceOf(FileNotFoundException.class, e.getCause());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLazyStartProducerOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:ok", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:fail").to("validator:org/apache/camel/component/validator/unknown.xsd?lazyStartProducer=true")).to("mock:result");
                ((RouteDefinition)this.from("direct:ok").to("validator:org/apache/camel/component/validator/schema.xsd?lazyStartProducer=true")).to("mock:result");
            }
        };
    }
}

