/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.validator.ValidatorEndpoint;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.urlhandler.pd.Handler;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorEndpointClearCachedSchemaTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorEndpointClearCachedSchemaTest.class);

    @Test
    public void testClearCachedSchema() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ExecutorService senderPool = Executors.newFixedThreadPool(5);
        ExecutorService executorClearCache = Executors.newFixedThreadPool(1);
        for (int i = 0; i < 5; ++i) {
            senderPool.execute(new Sender());
            if (i != 2) continue;
            executorClearCache.execute(new ClearCache());
        }
        senderPool.shutdown();
        executorClearCache.shutdown();
        senderPool.awaitTermination(4L, TimeUnit.SECONDS);
        mock.expectedMinimumMessageCount(5);
        mock.assertIsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("resource-loader-pd", (Object)new Handler());
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("validator:pd:somefile.xsd")).convertBodyTo(String.class)).to("log:after")).to("mock:result");
            }
        };
    }

    private void clearCachedSchema() {
        ModelCamelContext context = this.context;
        if (context == null) {
            return;
        }
        Collection endpoints = context.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            LOG.info("Endpoint URI: {}", (Object)endpoint.getEndpointUri());
            if (!endpoint.getEndpointUri().startsWith("validator:")) continue;
            ValidatorEndpoint xsltEndpoint = (ValidatorEndpoint)endpoint;
            xsltEndpoint.clearCachedSchema();
            LOG.info("schema cache cleared");
        }
    }

    private class Sender
    implements Runnable {
        private final String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><p:TestMessage xmlns:p=\"http://apache.camel.org/test\"><MessageContent>MessageContent</MessageContent></p:TestMessage>";
        private final byte[] messageBytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><p:TestMessage xmlns:p=\"http://apache.camel.org/test\"><MessageContent>MessageContent</MessageContent></p:TestMessage>".getBytes(StandardCharsets.UTF_8);

        private Sender() {
        }

        @Override
        public void run() {
            for (int j = 0; j < 5; ++j) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ValidatorEndpointClearCachedSchemaTest.this.sendBody("direct:start", this.messageBytes);
            }
        }
    }

    private class ClearCache
    implements Runnable {
        private ClearCache() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
                ValidatorEndpointClearCachedSchemaTest.this.clearCachedSchema();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

