/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.net.UnknownHostException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.BeforeEach;

public abstract class ValidatorDtdAccessAbstractTest
extends ContextTestSupport {
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;
    protected MockEndpoint unknownHostExceptionEndpoint;
    protected MockEndpoint validEndpoint;
    protected final String payloud = this.getPayloudPart("Hello world!");
    protected final String ssrfPayloud = "<!DOCTYPE roottag PUBLIC \"-//VSR//PENTEST//EN\" \"http://notex.isting/test\">\n" + this.payloud;
    protected final String xxePayloud = "<!DOCTYPE updateProfile [<!ENTITY file SYSTEM \"http://notex.istinghost/test\">]>\n" + this.getPayloudPart("&file;");
    private final boolean accessExternalDTD;

    public ValidatorDtdAccessAbstractTest(boolean accessExternalDTD) {
        this.accessExternalDTD = accessExternalDTD;
    }

    private String getPayloudPart(String bodyValue) {
        return "<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>" + bodyValue + "</body></mail>";
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.unknownHostExceptionEndpoint = this.resolveMandatoryEndpoint("mock:unknownHostException", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                if (ValidatorDtdAccessAbstractTest.this.accessExternalDTD) {
                    this.getContext().getGlobalOptions().put("CamelXmlValidatorAccessExternalDTD", "true");
                }
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doCatch(UnknownHostException.class).to("mock:unknownHostException")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

