/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileValidatorRouteTest
extends ContextTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    @Test
    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>", "CamelFileName", (Object)"valid.xml");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertTrue((boolean)FileUtil.deleteFile((File)this.testFile("valid.xml").toFile()), (String)"Should be able to delete the file");
    }

    @Test
    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>", "CamelFileName", (Object)"invalid.xml");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertTrue((boolean)FileUtil.deleteFile((File)this.testFile("invalid.xml").toFile()), (String)"Should be able to delete the file");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from(FileValidatorRouteTest.this.fileUri("?noop=true")).doTry().to("validator:org/apache/camel/component/validator/schema.xsd")).to("mock:valid")).doCatch(ValidationException.class).to("mock:invalid")).doFinally().to("mock:finally")).end();
            }
        };
    }
}

