/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerWithTimeOptionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testFiredInFutureWithTPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=10&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureWithTPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?period=0&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureWithTPatternFixedRate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=10&fixedRate=true&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureWithoutTPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=10&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureWithoutTPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=0&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureCustomPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=10&time=%s&pattern=dd-MM-yyyy HH:mm:ss.SSS", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureCustomPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                Date future = new Date(new Date().getTime() + 10L);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
                String time = sdf.format(future);
                this.fromF("timer://foo?delay=0&period=0&time=%s&pattern=dd-MM-yyyy HH:mm:ss.SSS", new Object[]{time}).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.context.start();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFiredInFutureIllegalTime() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.fromF("timer://foo?time=%s", new Object[]{"20090101"}).to("mock:result");
            }
        });
        Assertions.assertThrows(FailedToCreateRouteException.class, () -> this.context.start(), (String)"Should throw an exception");
    }
}

