/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Flaky when run in parallel test mode")
public class TimerSuspendCamelContextTest
extends ContextTestSupport {
    @Test
    public void testTimerSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(0);
        this.context.suspend();
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMinimumMessageCount(1);
        this.context.resume();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://foo?fixedRate=true&delay=0&period=10").to("mock:result");
            }
        };
    }
}

