/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerRouteTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TimerRouteTest.class);
    private final MyBean bean = new MyBean();

    @Test
    public void testTimerInvokesBeanMethod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((this.bean.counter.get() >= 2 ? 1 : 0) != 0, (String)("Should have fired 2 or more times was: " + this.bean.counter.get()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("timer://foo?fixedRate=true&delay=0&period=10").log("Fired timer")).to(new String[]{"bean:myBean", "mock:result"});
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.bean);
        return answer;
    }

    public static class MyBean {
        public final AtomicInteger counter = new AtomicInteger();

        public void someMethod() {
            LOG.debug("Invoked someMethod()");
            this.counter.incrementAndGet();
        }
    }
}

