/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerNegativeNoRepeatCountDelayTest
extends ContextTestSupport {
    @Test
    public void testNegativeDelay() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.context.getRouteController().stopRoute("routeTest");
        List exchanges = mock.getExchanges();
        for (Exchange exchange : exchanges) {
            Assertions.assertEquals((Object)"negativeDelay", (Object)exchange.getProperty("CamelTimerName"));
            Assertions.assertNotNull((Object)exchange.getProperty("CamelTimerFiredTime"));
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://negativeDelay?delay=-1&repeatCount=10&includeMetadata=true").routeId("routeTest").to("mock:result");
            }
        };
    }
}

