/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.timer.TimerEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerNameTest
extends ContextTestSupport {
    private final String uri = "timer://foo?delay=0&period=10&timerName=bar";

    @Test
    public void testTimerName() throws Exception {
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(1);
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
        TimerEndpoint te = (TimerEndpoint)this.context.getEndpoint("timer://foo?delay=0&period=10&timerName=bar", TimerEndpoint.class);
        Assertions.assertEquals((Object)"bar", (Object)te.getTimerName());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("timer://foo?delay=0&period=10&timerName=bar").autoStartup(false).to("mock:result");
            }
        };
    }
}

