/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerGracefulShutdownTest
extends ContextTestSupport {
    private final MyExceptionHandler eh = new MyExceptionHandler();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("eh", (Object)this.eh);
        return jndi;
    }

    @Test
    public void testTimerShutdown() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        Assertions.assertFalse((boolean)this.eh.isError(), (String)"Should not throw exception during graceful shutdown");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("timer:foo?period=10&delay=10&exceptionHandler=#eh").delay(10L).to("log:time")).to("mock:result");
            }
        };
    }

    private static final class MyExceptionHandler
    implements ExceptionHandler {
        private volatile boolean error;

        private MyExceptionHandler() {
        }

        public void handleException(Throwable exception) {
            this.error = true;
        }

        public void handleException(String message, Throwable exception) {
            this.error = true;
        }

        public void handleException(String message, Exchange exchange, Throwable exception) {
            this.error = true;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

