/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Timer;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.timer.TimerEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testTimerEndpoint() throws Exception {
        final TimerEndpoint te = new TimerEndpoint();
        te.setCamelContext((CamelContext)this.context);
        te.setTimer(new Timer(true));
        te.setEndpointUriIfNotSpecified("timer://foo");
        te.setPeriod(10L);
        te.setDelay(10L);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)te).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimerEndpointYetAgain() throws Exception {
        final TimerEndpoint te = new TimerEndpoint("timer://foo", this.context.getComponent("timer"), "foo");
        te.setTimer(new Timer(true));
        te.setPeriod(10L);
        te.setDelay(10L);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from((Endpoint)te).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTimerEndpointNoProducer() {
        Endpoint te = this.context.getEndpoint("timer://foo");
        Assertions.assertThrows(RuntimeCamelException.class, () -> ((Endpoint)te).createProducer(), (String)"Should have thrown an exception");
    }
}

