/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stub;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class StubTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:InOnly").setExchangePattern(ExchangePattern.InOnly)).to("stub:foo")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:InOut").setExchangePattern(ExchangePattern.InOut)).to("stub:foo")).to("mock:result");
            }
        };
    }

    final void test(ExchangePattern mep) throws InterruptedException {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").setExpectedMessageCount(1);
        this.template.sendBody("direct:" + mep.name(), (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInOnly() throws InterruptedException {
        this.test(ExchangePattern.InOnly);
    }

    @Test
    public void testInOut() throws InterruptedException {
        this.test(ExchangePattern.InOut);
    }
}

