/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stub;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.component.stub.StubEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class StubShadowTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StubComponent stub = (StubComponent)StubShadowTest.this.context.getComponent("stub", StubComponent.class);
                stub.setShadow(true);
                ((RouteDefinition)this.from("direct:start").to("stub:kafka:foo")).to("mock:result");
            }
        };
    }

    @Test
    public void testShadow() throws InterruptedException {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Endpoint se = this.context.getEndpoint("kafka://foo");
        StubShadowTest.assertIsInstanceOf(StubEndpoint.class, se);
    }
}

