/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SedaWireTapOnCompleteTest
extends ContextTestSupport {
    @Test
    public void testSeda() throws Exception {
        this.getMockEndpoint("mock:done").expectedHeaderValuesReceivedInAnyOrder("foo", new Object[]{"123", "456"});
        this.getMockEndpoint("mock:first").expectedHeaderReceived("foo", (Object)"123");
        this.getMockEndpoint("mock:second").expectedHeaderReceived("foo", (Object)"456");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.onCompletion().log("Done ${header.foo}")).to("mock:done");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("123"))).log("First ${header.foo}")).wireTap("seda:cheese").to("mock:first");
                ((RouteDefinition)((RouteDefinition)this.from("seda:cheese").setHeader("foo", (Expression)this.constant("456"))).log("Second ${header.foo}")).to("mock:second");
            }
        };
    }
}

