/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaWaitForTaskCompleteOnCompletionTest
extends ContextTestSupport {
    private static String done = "";

    @Test
    public void testAlways() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        SedaWaitForTaskCompleteOnCompletionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"CCCCA", (Object)done);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                done = done + "A";
                            }
                        });
                    }
                })).to("seda:foo?waitForTaskToComplete=Always")).process(new Processor(){

                    public void process(Exchange exchange) {
                        done = done + "B";
                    }
                })).to("mock:result");
                ((RouteDefinition)this.from("seda:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).process(new Processor(){

                    public void process(Exchange exchange) {
                        done = done + "C";
                    }
                })).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

