/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaUnitOfWorkTest
extends ContextTestSupport {
    private volatile Object foo;
    private volatile Object kaboom;
    private volatile String sync;
    private volatile String lastOne;

    @Test
    public void testSedaUOW() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
        notify.matchesWaitTime();
        Assertions.assertEquals((Object)"onCompleteA", (Object)this.sync);
        Assertions.assertEquals((Object)"onCompleteA", (Object)this.lastOne);
        Assertions.assertEquals((Object)"bar", (Object)this.foo, (String)"Should have propagated the header inside the Synchronization.onComplete() callback");
    }

    @Test
    public void testSedaUOWWithException() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "kaboom", (Object)"yes");
        notify.matchesWaitTime();
        Assertions.assertEquals((Object)"onFailureA", (Object)this.sync);
        Assertions.assertEquals((Object)"onFailureA", (Object)this.lastOne);
        Assertions.assertEquals((Object)"yes", (Object)this.kaboom, (String)"Should have propagated the header inside the Synchronization.onFailure() callback");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SedaUnitOfWorkTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyUOWProcessor(SedaUnitOfWorkTest.this, "A"))).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:foo").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertNull((Object)SedaUnitOfWorkTest.this.sync);
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) {
                        SedaUnitOfWorkTest.this.lastOne = "processor";
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) {
                        if ("yes".equals(exchange.getIn().getHeader("kaboom"))) {
                            throw new IllegalStateException("kaboom done!");
                        }
                        SedaUnitOfWorkTest.this.lastOne = "processor2";
                    }
                })).to("mock:result");
            }
        };
    }

    private static final class MyUOWProcessor
    implements Processor {
        private final SedaUnitOfWorkTest test;
        private final String id;

        private MyUOWProcessor(SedaUnitOfWorkTest test, String id) {
            this.test = test;
            this.id = id;
        }

        public void process(Exchange exchange) {
            exchange.getUnitOfWork().addSynchronization(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    test.sync = "onComplete" + id;
                    test.lastOne = test.sync;
                    test.foo = exchange.getIn().getHeader("foo");
                }

                public void onFailure(Exchange exchange) {
                    test.sync = "onFailure" + id;
                    test.lastOne = test.sync;
                    test.kaboom = exchange.getIn().getHeader("kaboom");
                }
            });
        }
    }
}

