/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaTimeoutTest
extends ContextTestSupport {
    private int timeout = 100;

    @Test
    public void testSedaNoTimeout() throws Exception {
        CompletableFuture out = this.template.asyncRequestBody("seda:foo", (Object)"World", String.class);
        Assertions.assertEquals((Object)"Bye World", out.get());
    }

    @Test
    public void testSedaTimeout() {
        CompletableFuture out = this.template.asyncRequestBody("seda:foo?timeout=" + this.timeout, (Object)"World", String.class);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, out::get, (String)"Should have thrown an exception");
        SedaTimeoutTest.assertIsInstanceOf(CamelExecutionException.class, e.getCause());
        SedaTimeoutTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause().getCause());
        SedaEndpoint se = (SedaEndpoint)this.context.getRoute("seda").getEndpoint();
        Assertions.assertNotNull((Object)se, (String)"Consumer endpoint cannot be null");
        Assertions.assertEquals((int)0, (int)se.getCurrentQueueSize(), (String)"Timeout Exchanges should be removed from queue");
    }

    @Test
    public void testSedaTimeoutWithStoppedRoute() throws Exception {
        this.context.getRouteController().stopRoute("seda");
        this.timeout = 500;
        this.testSedaTimeout();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.from("seda:foo").routeId("seda").to("mock:before")).delay(250L).transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
            }
        };
    }
}

