/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaSuspendConsumerStopRouteTest
extends ContextTestSupport {
    @Test
    public void testSedaSuspendConsumerStopRoute() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:start", SedaEndpoint.class);
        ((SedaConsumer)seda.getConsumers().iterator().next()).suspend();
        boolean stopped = this.context.getRouteController().stopRoute("foo", 2L, TimeUnit.SECONDS, true);
        Assertions.assertTrue((boolean)stopped, (String)"Route should be stopped");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStopped(), (String)"Route should be stopped");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:start").routeId("foo").to("mock:result");
            }
        };
    }
}

