/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaShouldNotUseSameThreadTest
extends ContextTestSupport {
    private static long id;

    @Test
    public void testNotUseSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                final ThreadLocal local = new ThreadLocal();
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) {
                        local.set("Hello");
                        id = Thread.currentThread().getId();
                    }
                })).to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertNull(local.get());
                        Assertions.assertNotSame((Object)id, (Object)Thread.currentThread().getId(), (String)"Thread is should not be same");
                    }
                })).to("mock:result");
            }
        };
    }
}

