/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaRouteTest
extends TestSupport {
    @Test
    public void testSedaQueue() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext context = new DefaultCamelContext();
        ((SedaComponent)context.getComponent("seda", SedaComponent.class)).setDefaultPollTimeout(10);
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:test.a").to("seda:test.b");
                this.from("seda:test.b").process(new Processor(){

                    public void process(Exchange e) {
                        log.debug("Received exchange: {}", (Object)e.getIn());
                        latch.countDown();
                    }
                });
            }
        });
        context.start();
        Endpoint endpoint = context.getEndpoint("seda:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        context.stop();
    }

    @Test
    public void testThatShowsEndpointResolutionIsNotConsistent() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultCamelContext context = new DefaultCamelContext();
        ((SedaComponent)context.getComponent("seda", SedaComponent.class)).setDefaultPollTimeout(10);
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:test.a").to("seda:test.b");
                this.from("seda:test.b").process(new Processor(){

                    public void process(Exchange e) {
                        log.debug("Received exchange: {}", (Object)e.getIn());
                        latch.countDown();
                    }
                });
            }
        });
        context.start();
        Endpoint endpoint = context.getEndpoint("seda:test.a");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("cheese", (Object)123);
        Producer producer = endpoint.createProducer();
        producer.process(exchange);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        context.stop();
    }
}

