/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.RepeatedTest;

public class SedaRemoveRouteThenAddAgainTest
extends ContextTestSupport {
    @RepeatedTest(value=5)
    public void testRemoveRouteAndThenAddAgain() throws Exception {
        MockEndpoint out = this.getMockEndpoint("mock:out");
        out.expectedMessageCount(1);
        out.expectedBodiesReceived(new Object[]{"before removing the route"});
        this.template.sendBody("seda:in", (Object)"before removing the route");
        out.assertIsSatisfied();
        this.context.getRouteController().stopRoute("sedaToMock");
        this.context.removeRoute("sedaToMock");
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        out = this.getMockEndpoint("mock:out");
        out.expectedMessageCount(1);
        out.expectedBodiesReceived(new Object[]{"after removing the route"});
        this.template.sendBody("seda:in", (Object)"after removing the route");
        out.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:in").routeId("sedaToMock").to("mock:out");
            }
        };
    }
}

