/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaQueueTest
extends ContextTestSupport {
    @Test
    public void testQueue() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Goodday World", "Bar"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo?size=20", (Object)"Bye World");
        this.template.sendBody("seda:foo?concurrentConsumers=5", (Object)"Goodday World");
        this.template.sendBody("seda:bar", (Object)"Bar");
    }

    @Test
    public void testQueueRef() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:array?queue=#arrayQueue", (Object)"Hello World");
        SedaEndpoint sedaEndpoint = this.resolveMandatoryEndpoint("seda:array?queue=#arrayQueue", SedaEndpoint.class);
        boolean b = sedaEndpoint.getQueue() instanceof ArrayBlockingQueue;
        Assertions.assertTrue((boolean)b);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SedaQueueTest.this.context.getRegistry().bind("arrayQueue", new ArrayBlockingQueue(10));
                this.from("seda:foo?size=20&concurrentConsumers=2").to("mock:result");
                this.from("seda:bar").to("mock:result");
                this.from("seda:array?queue=#arrayQueue").to("mock:result");
            }
        };
    }
}

