/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.ArrayBlockingQueueFactory;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaQueueFactoryTest
extends ContextTestSupport {
    private final ArrayBlockingQueueFactory<Exchange> arrayQueueFactory = new ArrayBlockingQueueFactory();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("arrayQueueFactory", this.arrayQueueFactory);
        return context;
    }

    @Test
    public void testArrayBlockingQueueFactory() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:arrayQueue?queueFactory=#arrayQueueFactory", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        ArrayBlockingQueue blockingQueue = SedaQueueFactoryTest.assertIsInstanceOf(ArrayBlockingQueue.class, queue);
        Assertions.assertEquals((int)1000, (int)blockingQueue.remainingCapacity(), (String)"remainingCapacity - default");
    }

    @Test
    public void testArrayBlockingQueueFactoryAndSize() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:arrayQueue100?queueFactory=#arrayQueueFactory&size=100", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        ArrayBlockingQueue blockingQueue = SedaQueueFactoryTest.assertIsInstanceOf(ArrayBlockingQueue.class, queue);
        Assertions.assertEquals((int)100, (int)blockingQueue.remainingCapacity(), (String)"remainingCapacity - custom");
    }

    @Test
    public void testDefaultBlockingQueueFactory() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:linkedQueue", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        SedaQueueFactoryTest.assertIsInstanceOf(LinkedBlockingQueue.class, queue);
    }
}

