/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SedaPurgeWhenStoppingTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final CountDownLatch latch2 = new CountDownLatch(1);

    @Test
    public void testPurgeWhenStopping() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        this.context.getRouteController().startRoute("myRoute");
        this.latch.await(2L, TimeUnit.SECONDS);
        this.context.getRouteController().stopRoute("myRoute");
        this.latch2.countDown();
        mock.setAssertPeriod(500L);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo?purgeWhenStopping=true").routeId("myRoute").autoStartup(false).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        SedaPurgeWhenStoppingTest.this.latch.countDown();
                        SedaPurgeWhenStoppingTest.this.latch2.await(2L, TimeUnit.SECONDS);
                    }
                })).to("mock:result");
            }
        };
    }
}

