/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SedaMultipleConsumersTest
extends ContextTestSupport {
    @Test
    public void testSedaMultipleConsumers() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSedaMultipleConsumersNewAdded() throws Exception {
        int i;
        this.getMockEndpoint("mock:a").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo?multipleConsumers=true").id("testRoute")).to("mock:c");
            }
        });
        this.resetMocks();
        this.getMockEndpoint("mock:a").expectedMessageCount(20);
        this.getMockEndpoint("mock:b").expectedMessageCount(20);
        this.getMockEndpoint("mock:c").expectedMessageCount(20);
        for (i = 0; i < 10; ++i) {
            this.template.sendBody("seda:foo", (Object)"Hello World");
            this.template.sendBody("seda:bar", (Object)"Bye World");
        }
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.context.getRouteController().suspendRoute("testRoute");
        this.getMockEndpoint("mock:a").expectedMessageCount(20);
        this.getMockEndpoint("mock:b").expectedMessageCount(20);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        for (i = 0; i < 10; ++i) {
            this.template.sendBody("seda:foo", (Object)"Hello World");
            this.template.sendBody("seda:bar", (Object)"Bye World");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo?multipleConsumers=true").to("mock:a");
                this.from("seda:foo?multipleConsumers=true").to("mock:b");
                this.from("seda:bar").to("seda:foo?multipleConsumers=true");
            }
        };
    }
}

