/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaInOutChainedWithOnCompletionTest
extends ContextTestSupport {
    @Test
    public void testInOutSedaChainedWithCustomOnCompletion() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"start"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"start-a"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"start-a-b", "onCustomCompletion"});
        String reply = (String)this.template.requestBody("seda:a", (Object)"start", String.class);
        Assertions.assertEquals((Object)"start-a-b-c", (Object)reply);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:a").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                SedaInOutChainedWithOnCompletionTest.this.template.sendBody("mock:c", (Object)"onCustomCompletion");
                            }
                        });
                    }
                })).to("mock:a")).transform((Expression)this.simple("${body}-a"))).to("seda:b");
                ((RouteDefinition)((RouteDefinition)this.from("seda:b").to("mock:b")).transform((Expression)this.simple("${body}-b"))).to("seda:c");
                ((RouteDefinition)this.from("seda:c").to("mock:c")).transform((Expression)this.simple("${body}-c"));
            }
        };
    }
}

