/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaInOutChainedTimeoutTest
extends ContextTestSupport {
    @Test
    public void testSedaInOutChainedTimeout() {
        StopWatch watch = new StopWatch();
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.requestBody("seda:a?timeout=5000", (Object)"Hello World"), (String)"Should have thrown an exception");
        ExchangeTimedOutException cause = SedaInOutChainedTimeoutTest.assertIsInstanceOf(ExchangeTimedOutException.class, e.getCause());
        Assertions.assertEquals((long)2000L, (long)cause.getTimeout());
        long delta = watch.taken();
        Assertions.assertTrue((delta < 4000L ? 1 : 0) != 0, (String)("Should be faster than 4000 millis, was: " + delta));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((RouteDefinition)((RouteDefinition)this.from("seda:a").to("mock:a")).to("seda:b?timeout=2000")).to("mock:a2");
                ((RouteDefinition)this.from("seda:b").to("mock:b")).delay(3000L).transform().constant((Object)"Bye World");
            }
        };
    }
}

