/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaFromRouteIdTest
extends ContextTestSupport {
    @Test
    public void testSedaFromRouteId() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"foo", (Object)((Exchange)foo.getReceivedExchanges().get(0)).getFromRouteId());
        Assertions.assertEquals((Object)"seda://foo", (Object)((Exchange)foo.getReceivedExchanges().get(0)).getFromEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"bar", (Object)((Exchange)bar.getReceivedExchanges().get(0)).getFromRouteId());
        Assertions.assertEquals((Object)"seda://bar", (Object)((Exchange)bar.getReceivedExchanges().get(0)).getFromEndpoint().getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).to("seda:bar");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

