/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.component.seda.SedaProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaEndpointTest
extends ContextTestSupport {
    private final BlockingQueue<Exchange> queue = new ArrayBlockingQueue<Exchange>(1000);

    @Test
    public void testSedaEndpointUnboundedQueue() throws Exception {
        LinkedBlockingQueue unbounded = new LinkedBlockingQueue();
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), unbounded);
        Assertions.assertNotNull((Object)seda);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)seda.getSize());
        Assertions.assertSame(unbounded, (Object)seda.getQueue());
        Assertions.assertEquals((int)1, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        Assertions.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        Assertions.assertEquals((int)1, (int)seda.getConsumers().size());
        Assertions.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    @Test
    public void testSedaEndpoint() throws Exception {
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), this.queue);
        Assertions.assertNotNull((Object)seda);
        Assertions.assertEquals((int)1000, (int)seda.getSize());
        Assertions.assertSame(this.queue, (Object)seda.getQueue());
        Assertions.assertEquals((int)1, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        Assertions.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        Assertions.assertEquals((int)1, (int)seda.getConsumers().size());
        Assertions.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    @Test
    public void testSedaEndpointTwo() throws Exception {
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), this.queue, 2);
        Assertions.assertNotNull((Object)seda);
        Assertions.assertEquals((int)1000, (int)seda.getSize());
        Assertions.assertSame(this.queue, (Object)seda.getQueue());
        Assertions.assertEquals((int)2, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        Assertions.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        Assertions.assertEquals((int)1, (int)seda.getConsumers().size());
        Assertions.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    @Test
    public void testSedaEndpointSetQueue() throws Exception {
        SedaEndpoint seda = new SedaEndpoint();
        Assertions.assertNotNull((Object)seda);
        seda.setCamelContext((CamelContext)this.context);
        seda.setEndpointUriIfNotSpecified("seda://bar");
        Assertions.assertNotNull((Object)seda.getQueue());
        seda.setQueue(new ArrayBlockingQueue(1000));
        seda.setConcurrentConsumers(2);
        Assertions.assertEquals((int)1000, (int)seda.getSize());
        Assertions.assertNotSame(this.queue, (Object)seda.getQueue());
        Assertions.assertEquals((int)2, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        Assertions.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        Assertions.assertEquals((int)1, (int)seda.getConsumers().size());
        Assertions.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    @Test
    public void testSedaConsumer() throws Exception {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda://foo", SedaEndpoint.class);
        Consumer consumer = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) {
            }
        });
        Assertions.assertSame((Object)seda, (Object)consumer.getEndpoint());
        Assertions.assertNotNull((Object)consumer.toString());
    }

    @Test
    public void testSedaDefaultValue() {
        SedaComponent sedaComponent = new SedaComponent();
        sedaComponent.setQueueSize(300);
        sedaComponent.setConcurrentConsumers(3);
        this.context.removeComponent("seda");
        this.context.addComponent("seda", (Component)sedaComponent);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda://foo", SedaEndpoint.class);
        Assertions.assertEquals((int)300, (int)seda.getSize());
        Assertions.assertEquals((int)3, (int)seda.getConcurrentConsumers());
    }
}

