/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.time.Duration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class SedaDiscardWhenFullTest
extends ContextTestSupport {
    @Test
    public void testDiscardWhenFull() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Camel World"});
        this.template.sendBody("seda:foo?discardWhenFull=true", (Object)"Hello World");
        this.template.sendBody("seda:foo?discardWhenFull=true", (Object)"Bye World");
        this.template.sendBody("seda:foo?discardWhenFull=true", (Object)"Hi World");
        this.context.getRouteController().startRoute("foo");
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> mock.getReceivedCounter() >= 1);
        this.template.sendBody("seda:foo?discardWhenFull=true", (Object)"Camel World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo?size=2").routeId("foo").autoStartup(false).to("mock:result");
            }
        };
    }
}

