/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaDiscardIfNoConsumerTest
extends ContextTestSupport {
    @Test
    public void testDiscard() throws Exception {
        SedaEndpoint bar = this.getMandatoryEndpoint("seda:bar", SedaEndpoint.class);
        Assertions.assertEquals((int)0, (int)bar.getCurrentQueueSize());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)bar.getCurrentQueueSize());
    }

    @Test
    public void testDiscardUoW() throws Exception {
        SedaEndpoint bar = this.getMandatoryEndpoint("seda:bar", SedaEndpoint.class);
        Assertions.assertEquals((int)0, (int)bar.getCurrentQueueSize());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        final MyCompletion myCompletion = new MyCompletion();
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.getExchangeExtension().addOnCompletion((Synchronization)myCompletion);
            }
        });
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)0, (int)bar.getCurrentQueueSize());
        Assertions.assertTrue((boolean)myCompletion.isCalled());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("seda:bar?discardIfNoConsumers=true")).to("mock:result");
            }
        };
    }

    private static final class MyCompletion
    extends SynchronizationAdapter {
        private boolean called;

        private MyCompletion() {
        }

        public void onDone(Exchange exchange) {
            this.called = true;
        }

        public boolean isCalled() {
            return this.called;
        }
    }
}

