/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaDefaultUnboundedQueueSizeTest
extends ContextTestSupport {
    @Test
    public void testSedaDefaultUnboundedQueueSize() {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        Assertions.assertEquals((int)0, (int)seda.getQueue().size());
        for (int i = 0; i < 1000; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        Assertions.assertEquals((int)1000, (int)seda.getQueue().size());
    }

    @Test
    public void testSedaDefaultBoundedQueueSize() {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo?size=500", SedaEndpoint.class);
        Assertions.assertEquals((int)0, (int)seda.getQueue().size());
        for (int i = 0; i < 500; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        Assertions.assertEquals((int)500, (int)seda.getQueue().size());
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("seda:foo", (Object)"Message overflow"), (String)"Should thrown an exception");
        SedaDefaultUnboundedQueueSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
    }
}

