/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.time.Duration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaComponent;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class SedaDefaultDiscardWhenFullTest
extends ContextTestSupport {
    @Test
    public void testDiscardWhenFull() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Camel World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo", (Object)"Bye World");
        this.template.sendBody("seda:foo", (Object)"Hi World");
        this.context.getRouteController().startRoute("foo");
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> mock.getReceivedCounter() >= 1);
        this.template.sendBody("seda:foo", (Object)"Camel World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SedaComponent seda = (SedaComponent)SedaDefaultDiscardWhenFullTest.this.context.getComponent("seda", SedaComponent.class);
                seda.setDefaultDiscardWhenFull(true);
                seda.setQueueSize(2);
                this.from("seda:foo").routeId("foo").autoStartup(false).to("mock:result");
            }
        };
    }
}

