/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class SedaDefaultBlockWhenFullTest
extends ContextTestSupport {
    private static final int QUEUE_SIZE = 1;
    private static final int DELAY = 100;
    private static final int DELAY_LONG = 1000;
    private static final String MOCK_URI = "mock:blockWhenFullOutput";
    private static final String SIZE_PARAM = "?size=%d";
    private static final String BLOCK_WHEN_FULL_URI = "seda:blockingFoo" + String.format("?size=%d", 1) + "&timeout=0";
    private static final String DEFAULT_URI = "seda:foo" + String.format("?size=%d", 1) + "&blockWhenFull=false&timeout=0";

    @Override
    protected Registry createCamelRegistry() throws Exception {
        SedaComponent component = new SedaComponent();
        component.setDefaultBlockWhenFull(true);
        Registry registry = super.createCamelRegistry();
        registry.bind("seda", (Object)component);
        return registry;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.fromF(BLOCK_WHEN_FULL_URI, new Object[0]).delay(1000L).to(SedaDefaultBlockWhenFullTest.MOCK_URI);
                this.from(DEFAULT_URI).delay(100L).to("mock:whatever");
            }
        };
    }

    @Test
    public void testSedaEndpoints() {
        Assertions.assertFalse((boolean)((SedaEndpoint)this.context.getEndpoint(DEFAULT_URI, SedaEndpoint.class)).isBlockWhenFull());
        Assertions.assertTrue((boolean)((SedaEndpoint)this.context.getEndpoint(BLOCK_WHEN_FULL_URI, SedaEndpoint.class)).isBlockWhenFull());
    }

    @Test
    public void testSedaDefaultWhenFull() {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(DEFAULT_URI, SedaEndpoint.class);
        Assertions.assertFalse((boolean)seda.isBlockWhenFull(), (String)"Seda Endpoint is not setting the correct default (should be false) for \"blockWhenFull\"");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.sendTwoOverCapacity(DEFAULT_URI, 1), (String)"The route didn't fill the queue beyond capacity: test class isn't working as intended");
        SedaDefaultBlockWhenFullTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
    }

    @Test
    public void testSedaBlockingWhenFull() throws Exception {
        this.getMockEndpoint(MOCK_URI).setExpectedMessageCount(3);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(BLOCK_WHEN_FULL_URI, SedaEndpoint.class);
        Assertions.assertEquals((int)1, (int)seda.getQueue().remainingCapacity());
        this.sendTwoOverCapacity(BLOCK_WHEN_FULL_URI, 1);
        this.assertMockEndpointsSatisfied();
    }

    private void sendTwoOverCapacity(String uri, int capacity) {
        for (int i = 0; i < capacity + 2; ++i) {
            this.template.sendBody(uri, (Object)("Message " + i));
        }
    }
}

