/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaConsumerSuspendResumeTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:bar");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        mock.assertIsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        SedaConsumer consumer = (SedaConsumer)this.context.getRoute("bar").getConsumer();
        ServiceHelper.suspendService((Object)consumer);
        Assertions.assertEquals((Object)"Suspended", (Object)consumer.getStatus().name());
        this.resetMocks();
        mock.expectedMessageCount(0);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class)).getQueue().isEmpty() && ((SedaEndpoint)this.context.getEndpoint("seda:bar", SedaEndpoint.class)).getQueue().isEmpty());
        Thread.sleep(1000L);
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(50L);
        this.resetMocks();
        mock.expectedMessageCount(1);
        ServiceHelper.resumeService((Object)consumer);
        Assertions.assertEquals((Object)"Started", (Object)consumer.getStatus().name());
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SedaConsumerSuspendResumeTest.this.context.setTracing(Boolean.valueOf(true));
                this.from("seda:foo").routeId("foo").to("seda:bar");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

