/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class SedaConfigureTest
extends ContextTestSupport {
    @Test
    public void testBlockingQueueConfigured() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?size=2000", SedaEndpoint.class);
        BlockingQueue queue = endpoint.getQueue();
        LinkedBlockingQueue blockingQueue = SedaConfigureTest.assertIsInstanceOf(LinkedBlockingQueue.class, queue);
        Assertions.assertEquals((int)2000, (int)blockingQueue.remainingCapacity(), (String)"remainingCapacity");
    }

    @Test
    public void testConcurrentConsumersConfigured() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?concurrentConsumers=5", SedaEndpoint.class);
        Assertions.assertEquals((int)5, (int)endpoint.getConcurrentConsumers(), (String)"concurrentConsumers");
    }

    @Test
    public void testBlockWhenFull() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo?size=2000&blockWhenFull=true", SedaEndpoint.class);
        Assertions.assertTrue((boolean)endpoint.isBlockWhenFull(), (String)"blockWhenFull");
    }

    @Test
    public void testDefaults() {
        SedaEndpoint endpoint = this.resolveMandatoryEndpoint("seda:foo", SedaEndpoint.class);
        Assertions.assertFalse((boolean)endpoint.isBlockWhenFull(), (String)"blockWhenFull: wrong default");
        Assertions.assertEquals((int)1, (int)endpoint.getConcurrentConsumers(), (String)"concurrentConsumers: wrong default");
        Assertions.assertEquals((int)1000, (int)endpoint.getSize(), (String)"size (remainingCapacity): wrong default");
        Assertions.assertEquals((long)30000L, (long)endpoint.getTimeout(), (String)"timeout: wrong default");
    }
}

