/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaConcurrentTest
extends ContextTestSupport {
    @Test
    public void testSedaConcurrentInOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        mock.setResultMinimumWaitTime(400L);
        for (int i = 0; i < 20; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSedaConcurrentInOnlyWithAsync() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        mock.setResultMinimumWaitTime(400L);
        for (int i = 0; i < 20; ++i) {
            this.template.asyncSendBody("seda:foo", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSedaConcurrentInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        ((MockValueBuilder)mock.allMessages().body()).startsWith((Object)"Bye");
        mock.setResultMinimumWaitTime(400L);
        ExecutorService executors = Executors.newFixedThreadPool(10);
        ArrayList<Future<Object>> replies = new ArrayList<Future<Object>>(20);
        int i = 0;
        while (i < 20) {
            final int num = i++;
            Future<Object> out = executors.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    return SedaConcurrentTest.this.template.requestBody("seda:bar", (Object)("Message " + num));
                }
            });
            replies.add(out);
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)20, (int)replies.size());
        executors.shutdownNow();
    }

    @Test
    public void testSedaConcurrentInOutWithAsync() throws Exception {
        Object out;
        int i;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        ((MockValueBuilder)mock.allMessages().body()).startsWith((Object)"Bye");
        mock.setResultMinimumWaitTime(400L);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        DefaultProducerTemplate pt = new DefaultProducerTemplate((CamelContext)this.context, executor);
        pt.start();
        ArrayList<CompletableFuture> replies = new ArrayList<CompletableFuture>(20);
        for (i = 0; i < 20; ++i) {
            out = pt.asyncRequestBody("seda:bar", (Object)("Message " + i));
            replies.add((CompletableFuture)out);
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)20, (int)replies.size());
        for (i = 0; i < 20; ++i) {
            out = (String)((Future)replies.get(i)).get();
            Assertions.assertTrue((boolean)((String)out).startsWith("Bye"));
        }
        pt.stop();
        executor.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo?concurrentConsumers=10").to("mock:before")).delay(500L).to("mock:result");
                ((ExpressionNode)((RouteDefinition)this.from("seda:bar?concurrentConsumers=10").to("mock:before")).delay(500L).transform((Expression)this.body().prepend((Object)"Bye "))).to("mock:result");
            }
        };
    }
}

