/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaConcurrentConsumersNPEIssueTest
extends ContextTestSupport {
    @Test
    public void testSendToSeda() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        FailedToStartRouteException e = (FailedToStartRouteException)Assertions.assertThrows(FailedToStartRouteException.class, () -> this.context.getRouteController().startRoute("first"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Failed to start route first because of Multiple consumers for the same endpoint is not allowed: seda://foo?concurrentConsumers=5", (Object)e.getMessage());
    }

    @Test
    public void testStartThird() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().startRoute("third");
        FailedToStartRouteException e = (FailedToStartRouteException)Assertions.assertThrows(FailedToStartRouteException.class, () -> this.context.getRouteController().startRoute("first"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Failed to start route first because of Multiple consumers for the same endpoint is not allowed: seda://foo?concurrentConsumers=5", (Object)e.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo?concurrentConsumers=5").routeId("first").autoStartup(false).to("mock:result");
                this.from("seda:foo?concurrentConsumers=5").routeId("second").to("mock:result");
                this.from("direct:foo").routeId("third").autoStartup(false).to("mock:result");
            }
        };
    }
}

