/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class SedaBlockWhenFullTest
extends ContextTestSupport {
    private static final int QUEUE_SIZE = 1;
    private static final int DELAY = 10;
    private static final int DELAY_LONG = 130;
    private static final String MOCK_URI = "mock:blockWhenFullOutput";
    private static final String SIZE_PARAM = "?size=%d";
    private static final String SEDA_WITH_OFFER_TIMEOUT_URI = "seda:blockingFoo" + String.format("?size=%d", 1) + "&blockWhenFull=true&offerTimeout=200";
    private static final String BLOCK_WHEN_FULL_URI = "seda:blockingBar" + String.format("?size=%d", 1) + "&blockWhenFull=true&timeout=0&offerTimeout=1000";
    private static final String DEFAULT_URI = "seda:foo" + String.format("?size=%d", 1);

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(BLOCK_WHEN_FULL_URI).delay(130L).syncDelayed().to(SedaBlockWhenFullTest.MOCK_URI);
                this.from(DEFAULT_URI).delay(10L).syncDelayed().to("mock:whatever");
            }
        };
    }

    @Test
    public void testSedaOfferTimeoutWhenFull() {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(SEDA_WITH_OFFER_TIMEOUT_URI, SedaEndpoint.class);
        Assertions.assertEquals((int)1, (int)seda.getQueue().remainingCapacity());
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.sendTwoOverCapacity(SEDA_WITH_OFFER_TIMEOUT_URI, 1), (String)("Failed to insert element into queue, after timeout of " + seda.getOfferTimeout() + " milliseconds"));
        SedaBlockWhenFullTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
    }

    @Test
    public void testSedaDefaultWhenFull() {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(DEFAULT_URI, SedaEndpoint.class);
        Assertions.assertFalse((boolean)seda.isBlockWhenFull(), (String)"Seda Endpoint is not setting the correct default (should be false) for \"blockWhenFull\"");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.sendTwoOverCapacity(DEFAULT_URI, 1), (String)"The route didn't fill the queue beyond capacity: test class isn't working as intended");
        SedaBlockWhenFullTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
    }

    @Test
    public void testSedaBlockingWhenFull() throws Exception {
        this.getMockEndpoint(MOCK_URI).setExpectedMessageCount(3);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(BLOCK_WHEN_FULL_URI, SedaEndpoint.class);
        Assertions.assertEquals((int)1, (int)seda.getQueue().remainingCapacity());
        this.sendTwoOverCapacity(BLOCK_WHEN_FULL_URI, 1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAsyncSedaBlockingWhenFull() throws Exception {
        this.getMockEndpoint(MOCK_URI).setExpectedMessageCount(2);
        this.getMockEndpoint(MOCK_URI).setResultWaitTime(390L);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint(BLOCK_WHEN_FULL_URI, SedaEndpoint.class);
        Assertions.assertEquals((int)1, (int)seda.getQueue().remainingCapacity());
        this.asyncSendTwoOverCapacity(BLOCK_WHEN_FULL_URI, 5);
        this.assertMockEndpointsSatisfied(2L, TimeUnit.SECONDS);
    }

    private void sendTwoOverCapacity(String uri, int capacity) {
        for (int i = 0; i < capacity + 2; ++i) {
            this.template.sendBody(uri, (Object)("Message " + i));
        }
    }

    private void asyncSendTwoOverCapacity(String uri, int capacity) {
        for (int i = 0; i < capacity + 2; ++i) {
            this.template.asyncSendBody(uri, (Object)("Message " + i));
        }
    }
}

