/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SedaAsyncProducerTest
extends ContextTestSupport {
    private String route = "";

    @Test
    public void testAsyncProducer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        CompletableFuture future = this.template.asyncRequestBody("direct:start", (Object)"Hello World", String.class);
        this.route = this.route + "send";
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"sendprocess", (Object)this.route, (String)"Send should occur before processor");
        String response = (String)future.get();
        Assertions.assertEquals((Object)"Bye World", (Object)response);
    }

    @Test
    public void testAsyncProducerWait() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setPattern(ExchangePattern.InOut);
        exchange.setProperty("CamelAsyncWait", (Object)WaitForTaskToComplete.IfReplyExpected);
        this.template.send("direct:start", (Exchange)exchange);
        this.route = this.route + "send";
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"processsend", (Object)this.route, (String)"Send should occur before processor");
        String response = (String)exchange.getMessage().getBody(String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)response);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((ExpressionNode)this.from("direct:start").delay(100L).process(new Processor(){

                    public void process(Exchange exchange) {
                        SedaAsyncProducerTest.this.route = SedaAsyncProducerTest.this.route + "process";
                        exchange.getMessage().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

