/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SameSedaQueueSizeAndNoSizeTest
extends ContextTestSupport {
    @Test
    public void testSameQueue() {
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("seda:foo", (Object)Integer.toString(i));
        }
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("seda:foo", (Object)"Should be full now"), (String)"Should fail");
        IllegalStateException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        if (!SameSedaQueueSizeAndNoSizeTest.isJavaVendor("ibm")) {
            Assertions.assertEquals((Object)"Queue full", (Object)ise.getMessage());
        }
    }

    @Test
    public void testSameQueueDifferentSize() {
        ResolveEndpointFailedException e = (ResolveEndpointFailedException)Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.template.sendBody("seda:foo?size=200", (Object)"Should fail"), (String)"Should fail");
        IllegalArgumentException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Cannot use existing queue seda://foo as the existing queue size 100 does not match given queue size 200", (Object)ise.getMessage());
    }

    @Test
    public void testSameQueueDifferentSizeBar() {
        ResolveEndpointFailedException e = (ResolveEndpointFailedException)Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.template.sendBody("seda:bar?size=200", (Object)"Should fail"), (String)"Should fail");
        IllegalArgumentException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Cannot use existing queue seda://bar as the existing queue size 1000 does not match given queue size 200", (Object)ise.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo?size=100").routeId("foo").autoStartup(false).to("mock:foo");
                this.from("seda:bar").routeId("bar").autoStartup(false).to("mock:bar");
            }
        };
    }
}

