/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SameSedaQueueMultipleConsumersDifferenceTest
extends ContextTestSupport {
    @Test
    public void testSameOptions() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo?multipleConsumers=true", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSameOptionsProducerStillOkay() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAddConsumer() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").routeId("fail").to("mock:fail");
            }
        }), (String)"Should have thrown exception");
        FailedToStartRouteException failed = SameSedaQueueMultipleConsumersDifferenceTest.assertIsInstanceOf(FailedToStartRouteException.class, e);
        Assertions.assertEquals((Object)"fail", (Object)failed.getRouteId());
        Assertions.assertEquals((Object)"Cannot use existing queue seda://foo as the existing queue multiple consumers true does not match given multiple consumers false", (Object)e.getCause().getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo?multipleConsumers=true").routeId("foo").to("mock:foo");
                this.from("seda:foo?multipleConsumers=true").routeId("bar").to("mock:bar");
            }
        };
    }
}

