/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSedaShutdownCompleteAllTasksTest
extends ContextTestSupport {
    @Test
    public void testShutdownCompleteAllTasks() throws Exception {
        final String url = this.fileUri("?initialDelay=0&delay=10");
        this.template.sendBodyAndHeader(url, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(url, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(url, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(url, (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader(url, (Object)"E", "CamelFileName", (Object)"e.txt");
        final CountDownLatch latch = new CountDownLatch(1);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(url).routeId("route1").shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).to("log:delay")).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo").routeId("route2").to("log:bar")).to("mock:bar")).process(new Processor(){
                    boolean first = true;

                    public void process(Exchange exchange) throws Exception {
                        latch.countDown();
                        if (this.first) {
                            Thread.sleep(100L);
                        }
                        this.first = false;
                    }
                });
            }
        });
        this.context.start();
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        latch.await(5L, TimeUnit.SECONDS);
        this.context.stop();
        Assertions.assertEquals((int)5, (int)bar.getReceivedCounter(), (String)"Should complete all messages");
    }
}

