/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectRequestReplyAndSedaInOnlyTest
extends ContextTestSupport {
    @Test
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:log").expectedBodiesReceived(new Object[]{"Logging: Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"Bye World", (Object)out);
        this.log.info("Got reply {}", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.constant("Bye World"))).to(ExchangePattern.InOnly, "seda:log");
                ((RouteDefinition)this.from("seda:log").transform((Expression)this.body().prepend((Object)"Logging: "))).to(new String[]{"log:log", "mock:log"});
            }
        };
    }
}

