/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwoSchedulerTest
extends ContextTestSupport {
    @Test
    public void testTwoScheduler() throws Exception {
        this.getMockEndpoint("mock:a").expectedMinimumMessageCount(4);
        this.getMockEndpoint("mock:b").expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
        String tn1 = (String)((Exchange)this.getMockEndpoint("mock:a").getReceivedExchanges().get(0)).getMessage().getHeader("tn", String.class);
        String tn2 = (String)((Exchange)this.getMockEndpoint("mock:b").getReceivedExchanges().get(0)).getMessage().getHeader("tn", String.class);
        Assertions.assertSame((Object)tn1, (Object)tn2);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("scheduler://foo?delay=100").setHeader("tn", (Expression)this.simple("${threadName}"))).to("mock:a");
                ((RouteDefinition)this.from("scheduler://foo?delay=200").setHeader("tn", (Expression)this.simple("${threadName}"))).to("mock:b");
            }
        };
    }
}

