/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.scheduler.SchedulerComponent;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class TwoSchedulerConcurrentTasksOneRouteTest
extends ContextTestSupport {
    private final AtomicBoolean sleep = new AtomicBoolean(true);

    @Test
    public void testTwoScheduler() throws Exception {
        this.getMockEndpoint("mock:done").expectedMinimumMessageCount(10);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SchedulerComponent comp = (SchedulerComponent)TwoSchedulerConcurrentTasksOneRouteTest.this.context.getComponent("scheduler", SchedulerComponent.class);
                comp.setPoolSize(2);
                ((RouteDefinition)((RouteDefinition)this.from("scheduler://foo?delay=250").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (TwoSchedulerConcurrentTasksOneRouteTest.this.sleep.compareAndSet(true, false)) {
                            log.info("Thread is sleeping");
                            Thread.sleep(1000L);
                            log.info("Thread is done sleeping");
                        }
                    }
                })).to("log:done")).to("mock:done");
            }
        };
    }
}

