/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SchedulerNoPolledMessagesTest
extends ContextTestSupport {
    @Test
    public void testSchedulerNoPolledMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(3);
        mock.message(0).arrives().between(0, 500).millis().beforeNext();
        mock.message(1).arrives().between(0, 500).millis().beforeNext();
        mock.message(2).arrives().between(500, 1500).millis().afterPrevious();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("scheduler://foo?delay=100&backoffMultiplier=10&backoffIdleThreshold=2&poolSize=2").log("Fired scheduler")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.setProperty("CamelSchedulerPolledMessages", (Object)false);
                    }
                })).to("mock:result");
            }
        };
    }
}

