/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.saga;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.saga.InMemorySagaService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SagaComponentTest
extends ContextTestSupport {
    @Test
    public void testManualCompletion() throws InterruptedException {
        MockEndpoint completed = this.getMockEndpoint("mock:completed");
        completed.expectedMessageCount(1);
        this.template.sendBody("direct:manual-workflow", (Object)"manual-complete");
        completed.assertIsSatisfied();
    }

    @Test
    public void testManualCompletionIsNotTriggeredAutomatically() throws InterruptedException {
        MockEndpoint completed = this.getMockEndpoint("mock:completed");
        completed.expectedMessageCount(1);
        completed.setResultWaitTime(1000L);
        this.template.sendBody("direct:manual-workflow", (Object)"do-not-complete");
        completed.assertIsNotSatisfied();
    }

    @Test
    public void testManualCompensationIsTriggeredOnly() throws InterruptedException {
        MockEndpoint completed = this.getMockEndpoint("mock:completed");
        completed.expectedMessageCount(1);
        completed.setResultWaitTime(1000L);
        MockEndpoint compensated = this.getMockEndpoint("mock:compensated");
        compensated.expectedMessageCount(1);
        this.template.sendBody("direct:manual-workflow", (Object)"manual-compensate");
        completed.assertIsNotSatisfied();
        compensated.assertIsSatisfied();
    }

    @Test
    public void testAutoCompletion() throws InterruptedException {
        MockEndpoint completed = this.getMockEndpoint("mock:completed");
        completed.expectedMessageCount(1);
        this.template.sendBody("direct:auto-workflow", (Object)"auto-complete");
        completed.assertIsSatisfied();
    }

    @Test
    public void testAutoCompensationIsTriggeredOnly() throws InterruptedException {
        MockEndpoint completed = this.getMockEndpoint("mock:completed");
        completed.expectedMessageCount(1);
        completed.setResultWaitTime(1000L);
        MockEndpoint compensated = this.getMockEndpoint("mock:compensated");
        compensated.expectedMessageCount(1);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:auto-workflow", (Object)"auto-compensate"), (String)"Should throw an exception");
        completed.assertIsNotSatisfied();
        compensated.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SagaComponentTest.this.context.addService((Object)new InMemorySagaService());
                this.from("direct:manual-workflow").saga().compensation("mock:compensated").completion("mock:completed").completionMode(SagaCompletionMode.MANUAL).to("seda:async");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("seda:async").choice().when(this.body().isEqualTo((Object)this.constant("manual-complete"))).to("saga:complete")).when(this.body().isEqualTo((Object)this.constant("manual-compensate"))).to("saga:compensate")).end();
                ((ChoiceDefinition)this.from("direct:auto-workflow").saga().completion("mock:completed").compensation("mock:compensated").choice().when(this.body().isEqualTo((Object)this.constant("auto-compensate"))).process(x -> {
                    throw new RuntimeException("mock exception");
                })).end().to("seda:async");
            }
        };
    }
}

