/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.component.rest.RestProducer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestProducerTest {
    private final CamelContext camelContext = new DefaultCamelContext();

    @Test
    public void shouldCreateMultipleQueryParameters() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        message.setHeader("multiple", Arrays.asList("value1", "value2", "value3"));
        Assertions.assertEquals((Object)"param=value1&param=value2&param=value3", (Object)RestProducer.createQueryParameters((String)"param={multiple}", (Message)message));
    }

    @Test
    public void shouldCreateMultipleOptionalQueryParameters() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        message.setHeader("multiple", (Object)Collections.EMPTY_LIST);
        Assertions.assertEquals((Object)"", (Object)RestProducer.createQueryParameters((String)"multiple={multiple?}", (Message)message));
    }

    @Test
    public void shouldCreateDefinedQueryParameters() throws UnsupportedEncodingException, URISyntaxException {
        Assertions.assertEquals((Object)"param=value", (Object)RestProducer.createQueryParameters((String)"param=value", null));
    }

    @Test
    public void shouldCreateOptionalPlaceholderQueryParametersForPresentValues() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        message.setHeader("paramPlaceholderName", (Object)"paramValue");
        Assertions.assertEquals((Object)"param=paramValue", (Object)RestProducer.createQueryParameters((String)"param={paramPlaceholderName?}", (Message)message));
    }

    @Test
    public void shouldCreatePlaceholderQueryParameters() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        message.setHeader("paramPlaceholderName", (Object)"paramValue");
        Assertions.assertEquals((Object)"param=paramValue", (Object)RestProducer.createQueryParameters((String)"param={paramPlaceholderName}", (Message)message));
    }

    @Test
    public void shouldCreateQueryNoParameters() throws UnsupportedEncodingException, URISyntaxException {
        Assertions.assertNull((Object)RestProducer.createQueryParameters(null, null));
    }

    @Test
    public void shouldNotCreateOptionalPlaceholderQueryParametersForMissingValues() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        Assertions.assertEquals((Object)"", (Object)RestProducer.createQueryParameters((String)"param={paramPlaceholderName?}", (Message)message));
    }

    @Test
    public void shouldSupportAllCombinations() throws UnsupportedEncodingException, URISyntaxException {
        DefaultMessage message = new DefaultMessage(this.camelContext);
        message.setHeader("requiredParamPlaceholder", (Object)"header_required_value");
        message.setHeader("optionalPresentParamPlaceholder", (Object)"header_optional_present_value");
        message.setHeader("multiple", Arrays.asList("value1", "value2", "value3"));
        message.setHeader("multipleOptional", (Object)Collections.EMPTY_LIST);
        Assertions.assertEquals((Object)"given=value&required=header_required_value&optional_present=header_optional_present_value&multiple=value1&multiple=value2&multiple=value3", (Object)RestProducer.createQueryParameters((String)"given=value&required={requiredParamPlaceholder}&optional={optionalParamPlaceholder?}&optional_present={optionalPresentParamPlaceholder?}&multiple={multiple}&multipleOptional={multipleOptional?}", (Message)message));
    }
}

