/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.component.rest.RestEndpointTest;
import org.apache.camel.component.rest.RestProducer;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestProducerPathTest {
    private final RestComponent restComponent;

    public RestProducerPathTest() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addComponent("mock-rest", (Component)new RestEndpointTest.MockRest());
        this.restComponent = new RestComponent();
        this.restComponent.setCamelContext((CamelContext)context);
    }

    private RestProducer createProducer(String uri) throws Exception {
        RestEndpoint restEndpoint = (RestEndpoint)this.restComponent.createEndpoint(uri);
        restEndpoint.setConsumerComponentName("mock-rest");
        restEndpoint.setParameters(new HashMap());
        restEndpoint.setHost("http://localhost");
        restEndpoint.setBindingMode("json");
        return (RestProducer)restEndpoint.createProducer();
    }

    @Test
    public void testEmptyParam() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list//{id}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertEquals((Object)"http://localhost/list//1", (Object)actual);
    }

    @Test
    public void testNoHeaders() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}_{val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testMissingHeader() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}/{val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertEquals((Object)"http://localhost/list/1/{val}", (Object)actual);
    }

    @Test
    public void testMissingHeaderSingleParam() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}_{val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testMissingStartCurlyBrace() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}_val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        message.setHeader("val", (Object)"test");
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testSingleMissingStartCurlyBrace() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/id}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testSingleMissingEndCurlyBrace() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testMissingEndCurlyBrace() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id_{val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        message.setHeader("val", (Object)"test");
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testSingleParam() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertEquals((Object)"http://localhost/list/1", (Object)actual);
    }

    @Test
    public void testUnderscoreSeparator() throws Exception {
        RestProducer producer = this.createProducer("rest:get:list/{id}_{val}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("id", (Object)1);
        message.setHeader("val", (Object)"test");
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertEquals((Object)"http://localhost/list/1_test", (Object)actual);
    }

    @Test
    public void testDotSeparator() throws Exception {
        RestProducer producer = this.createProducer("rest:get:items/item.{content-type}");
        Exchange exchange = producer.createExchange();
        Message message = exchange.getIn();
        message.setHeader("content-type", (Object)"xml");
        producer.process(exchange);
        String actual = (String)message.getHeader("CamelRestHttpUri");
        Assertions.assertEquals((Object)"http://localhost/items/item.xml", (Object)actual);
    }
}

